%     ,   
% " -  . :   "
% E-mail    : vestnikvmi@susu.ru


%   :
%0.          
%	    "tex".
%1.   ,     2  - example.tex, cmi.cls.
%2.   ,    \maketitle  .tex 
%        " " -   \justifying.
%3.  ! ,  ,       cmi.cls

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{cmi}
\LoadClass[twoside, 11pt, a4paper]{article}

% ---    ---
\usepackage[cp1251]{inputenc}
%\usepackage[utf8]{inputenc}
\usepackage[english, russian]{babel}
\usepackage[unicode=true,linktocpage=true]{hyperref}
%\usepackage{mmap} %  CMap-   PDF,       
\usepackage{array}
\usepackage{ragged2e}

% ---   ---
\renewcommand{\Large}{\fontsize{14pt}{19.6pt}\selectfont} %  ,  1
\renewcommand{\large}{\fontsize{12pt}{16.8pt}\selectfont} % ,  2,  3
\renewcommand{\footnotesize}{\fontsize{9pt}{12.6pt}\selectfont\parindent=6.5mm} % , 
\renewcommand{\normalsize}{\fontsize{11pt}{15.4pt}\selectfont} %  ,     ,  ,   
\renewcommand{\small}{\fontsize{10pt}{14pt}\justifying\selectfont}

\newcommand{\citationfont}{\fontsize{11pt}{15.4pt}\justifying\selectfont\parindent=6mm} % 

% ---     ---
\usepackage{totcount}
\regtotcounter{table}
\regtotcounter{figure}

% ---  ---
\usepackage{graphicx, epstopdf}
\graphicspath{{pic/}}

% ---       ---
\usepackage{indentfirst}

\usepackage{enumitem, changepage, fancyvrb}

% ---      ---
\usepackage[space]{cite}

\usepackage{amsfonts, amsmath, amssymb, amsthm}
%\usepackage{showframe} %      

% ---      ---
\let\oldenumerate\enumerate
\let\endoldenumerate\endenumerate
\def\enumerate{% FIXME: add support of optional arguments
	\oldenumerate[topsep=0pt, itemsep=0pt, parsep=0pt, widest=9, leftmargin=7mm]
}
\def\enumerateparen{% FIXME: delete this one if the trick with enumerate works
	\oldenumerate[topsep=0pt, itemsep=0pt, parsep=0pt, label=\arabic*), widest=9, leftmargin=7mm]
}
\let\endenumerateparen\endoldenumerate

%% ---  ---
%\newcommand{\ps@vestnikfirst}{
%	%    
%	\renewcommand{\@oddfoot}{%
%		\vbox{%
%			\phantom{eee}%
%			\hrule%
%			\vskip 4pt%
%			\hbox to \textwidth{%
%				\textbf{2013, .~2, \No~1}\hfil\thepage%
%			}%
%		}%
%	}
%	\renewcommand{\@evenfoot}{%
%		\vbox{%
%			\phantom{eee}%
%			\hrule%
%			\vskip 4pt%
%			\hbox to \textwidth{%
%				\thepage\hfil\textbf{ .  <<   >>}%
%			}%
%		}%
%	}
%	%    
%	\renewcommand{\@oddhead}{}
%	\renewcommand{\@evenhead}{}
%}
%
%\newcommand{\ps@vestnik}{
%	\setlength{\textwidth}{161mm}% {   }
%	%    
%	\renewcommand{\@oddfoot}{%
%		\vbox{%
%			\phantom{eee}%
%			\hrule%
%			\vskip 4pt%
%			\hbox to \textwidth{%
%				\textbf{2013, .~2, \No~1}\hfil\thepage%
%			}%
%		}%
%	}
%	\renewcommand{\@evenfoot}{%
%		\vbox{%
%			\phantom{eee}%
%			\hrule%
%			\vskip 4pt%
%			\hbox to \textwidth{%
%				\thepage\hfil\textbf{ .  <<   >>}%
%			}%
%		}%
%	}
%
%	%    
%	\renewcommand{\@oddhead}{%
%		\raisebox{0pt}[\headheight][0pt]{%
%			\vbox{%
%				\hbox to \textwidth{\hfil\small{\textbf{\leftmark}}\hfil}%
%				\vskip 3pt%
%				\hrule%
%			}%
%		}%
%	}
%	\renewcommand{\@evenhead}{%
%		\raisebox{0pt}[\headheight][0pt]{%
%			\vbox{%
%				\hbox to \textwidth{\hfil\small{\textbf{\rightmark}}\hfil}%
%				\vskip 3pt%
%				\hrule%
%			}%
%		}%
%	}
%}

% ---   ---
\let\@classification\@empty
\def\classify#1{\def\@classification{#1}}

% ---   ---
%\let\@address\@empty
%\def\@address{}
%\let\@email\@empty
%\def\@email#1{#1}
%\let\@received\@empty
%\def\@received#1{#1}


\newtoks\address
\def\address#1{\gdef\@address{#1}\centering}
%or \newcommand{\address}[1]{\gdef\@address{#1}\centering}

\newtoks\email
\def\email#1{\gdef\@email{#1}\centering}

\newtoks\received
\def\received#1{\gdef\@received{#1}\centering}


\renewcommand{\maketitle}{%
	\ifx\@firsttitle\indefined%     
%		\thispagestyle{vestnikfirst}%   
		\def\@firsttitle{}
	\fi

	\ifx \@classification \@empty%   
		\vspace{10pt} %    
	\else%
		{\large{\begin{flushleft}\textbf{\@classification}\end{flushleft}}}%  -  
	\fi%
	{\noindent\Large\centering\textbf{\@title}\par\vskip 10pt}% , 
	{\noindent\large\centering\textbf{\@author}\vskip 3pt}% 
	{\noindent\large\centering\textit{\@address}\\} %  
	{\noindent\large\centering\textit{\@email} \\} % email
	{\noindent\large\centering{\@received}\\} %    
	\smallskip%
}

% ---    ---
\renewcommand{\@seccntformat}[1]{\csname the#1\endcsname.\hspace{0.7em}}

% ---    ---
\widowpenalty=10000 %  
\clubpenalty=10000 %  

\usepackage{ifthen,latexsym}

\normalsize
\usepackage[margin=2.5cm]{geometry}

% ---      ---
\let\olditemize\itemize
\let\endolditemize\enditemize
\def\itemize{
	\olditemize[topsep=0pt, itemsep=0pt, parsep=0pt]
}

% ---   ---
\parindent=7mm
\parskip=0mm
\leftskip=0mm
\rightskip=0mm

% ---       
\abovedisplayskip=12pt plus 3pt minus 3pt
\belowdisplayskip=12pt plus 3pt minus 3pt
\abovedisplayshortskip=0pt plus 3pt
\belowdisplayshortskip=6pt plus 3pt

\pagestyle{empty}

% ---   
\setcounter{totalnumber}{4}
\setcounter{topnumber}{4}
\setcounter{bottomnumber}{4}
\renewcommand{\textfraction}{0.01}
\renewcommand{\topfraction}{0.99}
\renewcommand{\bottomfraction}{0.99}

\newcommand{\sectspacm}{\hspace*{-\medskipamount}}
\newcommand{\sectspacp}{\hspace*{\medskipamount}}

\renewcommand{\section}{%
	\@startsection{section}{1}{0mm}{0.2\baselineskip}{0.5\baselineskip}{\normalfont\raggedright\Large\bf}%
}

\renewcommand{\subsection}{%
	\@startsection{subsection}{2}{0mm}{-\baselineskip}{0.5\baselineskip}{\normalfont\raggedright\large\bf}%
}

\renewcommand{\subsubsection}{%
	\@startsection{subsubsection}{3}{0mm}{-\baselineskip}{0.5\baselineskip}{\normalfont\raggedright\large\it}%
}

% ---  ---
\newcounter{theocounter}
\newenvironment{theorem}{%
	\refstepcounter{theocounter}\par\addvspace{3mm}\noindent%
	{\bf  \thetheocounter.\ }%
}{%
	\par\addvspace{3mm}%
}

% ---    ---
\newenvironment{theorem*}{%
	\refstepcounter{theocounter}\par\addvspace{3mm}\noindent%
	{\bf .\ }\begin{it}%
}{%
	\end{it}\par\addvspace{3mm}
}

% ---  ---
\newcounter{lemcounter}
\newenvironment{lemma}{%
	\refstepcounter{lemcounter}\par\addvspace{3mm}\noindent
	{\bf  \thelemcounter.\ }%
}{%
	\par\addvspace{3mm}%
}

% ---  ---
\newcounter{remcounter}
\newenvironment{remark}{%
	\refstepcounter{remcounter}\par\addvspace{3mm}\noindent
	{\bf  \theremcounter.\ }%
}{%
	\par\addvspace{3mm}%
}

% ---  ---
\newcounter{defcounter}
\newenvironment{definition}{%
	\refstepcounter{defcounter}\par\addvspace{3mm}\noindent
	{\bf  \thedefcounter.\ }%
}{%
	\par\addvspace{3mm}%
}

% ---  ---
\newcounter{examcounter}
\newenvironment{example}{%
	\refstepcounter{examcounter}\par\addvspace{3mm}\noindent
	{\bf  \theexamcounter.\ }%
}{%
	\par\addvspace{3mm}%
}

% ---  ---
\newcounter{propcounter}
\newenvironment{proposition}{%
	\refstepcounter{propcounter}\par\addvspace{3mm}\noindent
	{\bf  \thepropcounter.\ }%
}{%
	\par\addvspace{3mm}%
}

% ---  ---
\newcounter{corcounter}
\newenvironment{corollary}{%
	\refstepcounter{corcounter}\par\addvspace{3mm}\noindent%
	{\bf  \thecorcounter.\ }%
}{%
	\par\addvspace{3mm}%
}

%  
\newenvironment{biblio}[1][9]{% \begin{biblio}[maxval] ...
	\renewcommand{\refname}{}%
	\begin{thebibliography}{#1}%
	\itemsep 0pt%
}{%
	\end{thebibliography}%
}
\newenvironment{biblio_lat}[1][9]{%
	\renewcommand{\refname}{References}%
	\begin{thebibliography}{#1}%
	\itemsep 0pt%
}{%
	\end{thebibliography}%
}
\renewcommand{\@biblabel}[1]{#1.} %   

\newcommand{\R}{\mathbb{R}}
\newcommand{\N}{\mathbb{N}}
\newcommand{\Z}{\mathbb{Z}}
\newcommand{\CP}{\mathbb{C}}
\newcommand\Paragraph{\textsection}

\newcommand{\keywords}[1]{%
	{\footnotesize\it  :~#1}%
}
\newcommand{\keywordsen}[1]{%
	{\footnotesize\it Keywords:~#1}%
}

\renewenvironment{abstract}{%
	\vspace{8pt}
	\footnotesize
	\begin{adjustwidth}{0mm}{0em}%
		\hspace{2em}%
}{%
	\end{adjustwidth}
}

\newenvironment{citationplace}{%
	\begin{adjustwidth}{0mm}{0em}%
		\citationfont%
		\hspace{6mm}%
	}{%
\end{adjustwidth}
}

\newenvironment{citationexample}{%
	\large
	\textbf
	\flushleft
	\begin{adjustwidth}{0mm}{0em}%
	}{%
\end{adjustwidth}
}

\renewcommand\newblock{\hskip .11em plus .33em minus .07em}
\sloppy
\sfcode`\.=1000\relax

%       
\setlength{\intextsep}{1em}

% ---      ---
\abovecaptionskip=0pt
\belowcaptionskip=0pt
\newlength{\@tblwid}
\setlength{\@tblwid}{10cm}
\renewcommand{\@makecaption}[2]{%
	\def\@tabenvname{table}%
	\ifx\@currenvir\@tabenvname%
		% we're in a table environment
		\vspace{\abovecaptionskip}%
		\centering\parbox{\@tblwid}{%
			{\flushright\textbf{\ifthenelse{\totvalue{table} > 1}{#1}{\tablename}}\par\vspace{-1em}}%
			{\center #2\par\vspace{2mm}}%
		}
		\vspace{\belowcaptionskip}%
	\else%
		% we're in a figure environment
		\vspace{\abovecaptionskip}%
		\sbox{\@tempboxa}{{#1. #2}}%
		\ifdim \wd\@tempboxa >\hsize%
			{\textbf{\small\ifthenelse{\totvalue{figure} > 1}{#1.}{\figurename}} #2}%
		\else%
			\global\@minipagefalse%
			\hbox to \hsize {\textbf{\small\hfil\ifthenelse{\totvalue{figure} > 1}{#1.}{\figurename}} #2 \hfil}%
		\fi%
		\vspace{\belowcaptionskip}%
	\fi%
}

% ---  ---
\newcommand{\tabref}[1]{.~\ref{#1}} %    
\newsavebox{\@tblbox}
\newcommand{\tab}[3]{% label, caption, data
	\begin{table}[h]%
	\sbox{\@tblbox}{#3}%    
	\settowidth{\@tblwid}{\usebox{\@tblbox}}%    
	\caption{#2}%
	\label{#1}%
	\centering%
	\usebox{\@tblbox}%   
	\end{table}%
}

% ---  ---
\newcommand{\figref}[1]{.~\ref{#1}} %    
\newcommand{\fig}[3]{% params, label, caption
	\begin{figure}[h]%
		\centering%
		\includegraphics[#1]{#2}%
		\caption{#3}%
		\label{#2}%
	\end{figure}%
}

% ---   ---
\newcommand{\code}[4][\linewidth]{% width, params, label, caption
	\begin{figure}[h]%
		\centering%
		\topsep=0pt%
		\partopsep=0pt%
		\begin{minipage}{#1}
		{
		\small\VerbatimInput[#2]{#3}

		}%
		\end{minipage}
		\vskip 3pt
		\caption{#4}%
		\label{#3}%
	\end{figure}%
}

% ---     ---
\newcommand{\codenonum}[3]{% params, label, caption
	\begin{figure}[h]%
		\centering%
		\topsep=0pt%
		\partopsep=0pt%
		\begin{minipage}{\linewidth}
		{
		\small\VerbatimInput[#1]{#2}

		}%
		\end{minipage}
		\vskip 3pt
		#3%
		\label{#2}%
	\end{figure}%
}

% ---  
\newcommand{\fignofloat}[3]{% params, label, caption
	\center%
	\includegraphics[#1]{#2}%
	\caption{#3}%
	\label{#2}%
}

\newcommand{\MakeUppercaseWithNewline}[1]{%
	\begingroup
		\let\SavedOrgNewline\\%
		\DeclareRobustCommand{\\}{\SavedOrgNewline}%
		\MakeTextUppercase{#1}%
	\endgroup
}

\renewcommand\@makefntext[1]{%
	\noindent\@makefnmark #1%
}

% vim: syntax=tex
